//
// Clear class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include <memory.h>
#include "Clear.h"
#include "Color.h"
#include "Error.h"
#include "Format.h"




Clear::Clear()
{ 
    // Initialise HERMES (probably reference count increase only by now)
    if (!Hermes_Init()) 
    throw Error("Could not initialise HERMES");

    // Create a new format object 
    m_format=new Format();
 
    // Get new clearer instance from Hermes 
    m_handle=Hermes_ClearerInstance();

    if (!m_handle)
    throw Error("Could not obtain clearer instance from HERMES"); 
}


Clear::~Clear()
{ 
    // Return the Clearer instance
    Hermes_ClearerReturn(m_handle);

    // Delete our format
    delete m_format;
}


void Clear::request(const Format &format)
{ 
    // Request surface clear for this format
    if(!Hermes_ClearerRequest(m_handle,
			      const_cast<HermesFormat*>(&format.m_format)))
    throw Error("Requested colour format cannot be cleared");

    *m_format=format;
}



void Clear::clear(void *pixels,int x,int y,int width,int height,int pitch,
  const Color &color)
{ 
    int32 r,g,b;

    if (m_format->indexed() && color.direct())
    throw Error("Can't clear indexed surface with direct colour");
    else
    if (m_format->direct() && color.indexed())
    throw Error("Can't clear direct surface with indexed colour");


    // Call Hermes_ClearerClear with different parameters depending on what
    // colour we have

    if(color.direct())
    { r=(int32)(color.r()*(float)255.0);
      g=(int32)(color.g()*(float)255.0);
      b=(int32)(color.b()*(float)255.0);

      Hermes_ClearerClear(m_handle,pixels,x,y,width,height,pitch,r,g,b,0);
    }
    else
    Hermes_ClearerClear(m_handle,pixels,x,y,width,height,pitch,0,0,0,
			color.index());

}





