//
// Palette example for PTC 2.0 C++ API
// Copyright (c) Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU GPL
//

// include files
#include "ptc.h"
#include <stdlib.h>


inline int random(int max)
{
    // random number
    return rand() % max;
}


void main()
{
    try
    {
        // create console
        Console console;

        // create format
        Format format(8);

        // open console
        console.open("Palette example",format);

        // create surface
        Surface surface(console.width(),console.height(),format);
        
        // create palette
        Palette palette;

        // generate palette
        int32 data[256];
        for (int i=0; i<256; i++) data[i] = i;

        // load palette data
        palette.load(data);

        // set console palette
        console.palette(palette);
        
        // set surface palette
        surface.palette(palette);

        // loop until a key is pressed
        while (!console.key())
        {
            // lock surface
            char8 *pixels = (char8*) surface.lock();

            // get surface dimensions
            int width  = surface.width();
            int height = surface.height();

            // draw random pixels
            for (int i=0; i<100; i++)
            {
                // get random position
                int x = random(width);
                int y = random(height);

                // get random color index
                char8 index = random(256);

                // draw color [index] at position [x,y]
                pixels[x+y*width] = index;
            }
        
            // unlock surface
            surface.unlock();

            // copy to console
            surface.copy(console);

            // update console
            console.update();
        }
    }
    catch (Error &error)
    {
        // report error
        error.report();
    }
}
