//
// Surface clear demonstration program for PTC 2.0 C++ API
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// The PTC 2.0 C++ API is (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//
// Please note that THIS IS NEITHER A RECTANGLE DRAWING DEMOSTRATION NOR A
// BENCHMARK, even if it looks like it :)
// It shows how to clean parts of a surface or the whole surface with PTC.
//

#include <time.h>
#include <stdlib.h>
#include "ptc.h"

int random(int size)
{ return rand()%size;
}

int main()
{ srand(time(NULL));

  try {
    Format format(32,0xff0000,0xff00,0xff);

    // Open a 400x400 window
    Console console;
    //    console.option("dga pedantic init");
    console.open("Clear example",403,403,format);

    // Get a surface 
    Surface surface(console.width(),console.height(),format);
    
    while(!console.key())
    { // Generate a random rectangle that fits in the surface 
      
      int x1=random(surface.width());
      int y1=random(surface.height());
      int x2=random(surface.width());
      int y2=random(surface.height());

      // Coordinates have to be the right way round for PTC!
      
      if(x1>x2) { int tmp=x1; x1=x2; x2=tmp; }
      if(y1>y2) { int tmp=y1; y1=y2; y2=tmp; }

      // Generate a random fill colour (or color :)
     
      float r=(float)random(255);
      float g=(float)random(255);
      float b=(float)random(255);

      Color color(r/(float)255,g/(float)255,b/(float)255);

      // Use both to clear a surface area

      surface.clear(color,Area(x1,y1,x2,y2));

      // Uncomment this to clear the whole surface
      // surface.clear(color);

      // Copy the surface to the console. We only need to copy the area 
      // we changed anyway.. 

      surface.copy(console,Area(x1,y1,x2,y2),Area(x1,y1,x2,y2));

      // Update the console. On some systems, only the Area we pass to it
      // will be updated, on others the whole screen
 
      console.update(Area(x1,y1,x2,y2));
    }

    return 0;
  }
  catch(Error e)
  { e.report();
  }
}
