//
// VGA Interface class for PTC 2.0 C++ API
// Copyright (c) 1998 Jonathan Matthew (jmatthew@uq.net.au)
// The PTC 2.0 C++ API is (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//


#ifndef __PTC_VGA_H
#define __PTC_VGA_H

#include "dpmi.h"
#include "types.h"
#include "format.h"
#include "error.h"

// mode types
#define FAKEMODE    0
#define RGB332      1
#define INDEX8      2

// fakemode types
#define FAKEMODE1A  0
#define FAKEMODE1B  1
#define FAKEMODE1C  2
#define FAKEMODE2A  3
#define FAKEMODE2B  4
#define FAKEMODE2C  5
#define FAKEMODE3A  6
#define FAKEMODE3B  7
#define FAKEMODE3C  8

class VGA
{
    public:

        // constructor - sets mode
        VGA(int xres, int yres, int modetype, int faketype);

        // destructor - returns to text mode
        ~VGA();

        // palette set
        void palette(const int32 *data);

        // wait for retrace
        void wait_retrace();

        // fakemode console load
        void fakemode_load(char *src, int wvr);

        // "locking"
        void *lock();
        void unlock();

        // data access
        inline int width();
        inline int height();
        inline int pitch();
        inline int pages();
        inline int fakemode();
        Format &format();

    private:

        // memory clearing
        void clear_memory();

        // data
        int m_init;         // initialisation flag
        char *m_ptr;        // console ptr
        Format m_format;    // console format
        int m_width;
        int m_height;
        int m_pitch;
        int m_pages;
        int m_mode_type;    // 0=FAKEMODE, 1=RGB332, 2=INDEX8
        int m_fake_type;    // #defines above
};

inline int VGA::width()
{
    return m_width;
}

inline int VGA::height()
{
    return m_height;
}

inline int VGA::pitch()
{
    return m_pitch;
}

inline int VGA::pages()
{
    return m_pages;
}

inline int VGA::fakemode()
{
    return (m_mode_type == FAKEMODE);
}

#endif
