//
// Palette class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include <memory.h>
#include <string.h>
#include "Error.h"
#include "Palette.h"




Palette::Palette()
{
    // clear locked flag
    m_locked = false;

    // clear palette
    memset(m_data,0,1024);
}


Palette::Palette(const Palette &other)
{
    // clear locked flag
    m_locked = false;

    // assignment
    *this = other;
}


Palette::~Palette()
{
    // destructor
}




int32* Palette::lock()
{
    // check locked flag
    if (m_locked) throw Error("palette is already locked");

    // set locked flag
    m_locked = true;

    // lock palette
    return m_data;
}


void Palette::unlock()
{
    // check locked flag
    if (!m_locked) throw Error("palette is not locked");

    // reset locked flag
    m_locked = false;
}




void Palette::load(const int32 data[])
{
    // load palette data
    memcpy(m_data,data,1024);
}




void Palette::save(int32 data[]) const
{
    // save palette data
    memcpy(data,m_data,1024);
}




const int32* Palette::data() const
{
    // get palette data
    return m_data;
}




Palette& Palette::operator =(const Palette &other)
{
    // assignment
    memcpy(m_data,other.m_data,1024);
    return *this;
}


bool Palette::operator ==(const Palette &other) const
{
    // is equal to
    if (memcmp(m_data,other.m_data,1024)==0) return true;
    else return false;
}


bool Palette::operator !=(const Palette &other) const
{
    // not equal to
    return !(*this==other);
}
