# Watcom C++ makefile for ptc-dos-2.0.5

!ifeq config debug
cppoption = -xs -bt=dos -zq -d2
lib = ..\library\debug\ptc.lib
objdir = ..\library\debug
!else
config=release
cppoption = -xs -oneatx -bt=dos -zq
lib = ..\library\release\ptc.lib
objdir = ..\library\release
!endif

ASM_FLAGS= -f win32

objs1 = $(objdir)\area.obj &
        $(objdir)\clear.obj &
        $(objdir)\clip.obj
objs2 = $(objdir)\color.obj &
        $(objdir)\copy.obj &
        $(objdir)\console.obj
objs3 = $(objdir)\error.obj &
        $(objdir)\format.obj &
        $(objdir)\surface.obj
objs4 = $(objdir)\vbe.obj &
        $(objdir)\vga.obj &
        $(objdir)\dpmi.obj
objs5 = $(objdir)\palette.obj &
        $(objdir)\near.obj

!ifeq asm yes
asmfiles = $(objdir)\x86_fake.obj
!else
cppoption += -dNO_ASSEMBLER
!endif

.silent

.cpp.obj :
        wpp386 $[@ $(cppoption) -fo=$@

.asm.obj :
        nasm $(asm_flags) -o $@ $[@


$(lib) : hello $(objs1) $(objs2) $(objs3) $(objs4) $(objs5) $(asmfiles)
        wlib -q -n -b $(lib) $(objs1)
        wlib -q -b $(lib) $(objs2)
        wlib -q -b $(lib) $(objs3)
        wlib -q -b $(lib) $(objs4)
        wlib -q -b $(lib) $(objs5)
!ifeq asm yes
        wlib -q -b $(lib) $(asmfiles)
!endif

hello : .SYMBOLIC
        echo Compiling $(config) library..

clean : .SYMBOLIC
        echo deleting library objects..
        if exist ..\library\debug\*.obj del ..\library\debug\*.obj
        if exist ..\library\release\*.obj del ..\library\release\*.obj
        if exist *.err del *.err
        if exist *.bak del *.bak

clobber : clean .SYMBOLIC
        echo deleting libraries..
        if exist ..\library\debug\ptc.lib del ..\library\debug\ptc.lib
        if exist ..\library\release\ptc.lib del ..\library\release\ptc.lib

$(objdir)\area.obj     : area.cpp area.h .AUTODEPEND
$(objdir)\clear.obj    : clear.cpp clear.h .AUTODEPEND
$(objdir)\clip.obj     : clip.cpp clip.h .AUTODEPEND
$(objdir)\color.obj    : color.cpp color.h .AUTODEPEND
$(objdir)\copy.obj     : copy.cpp copy.h .AUTODEPEND
$(objdir)\console.obj  : console.cpp console.h .AUTODEPEND
$(objdir)\error.obj    : error.cpp error.h .AUTODEPEND
$(objdir)\format.obj   : format.cpp format.h .AUTODEPEND
$(objdir)\surface.obj  : surface.cpp surface.h .AUTODEPEND
$(objdir)\palette.obj  : palette.cpp palette.h .AUTODEPEND
$(objdir)\vbe.obj      : vbe.cpp vbe.h .AUTODEPEND
$(objdir)\vga.obj      : vga.cpp vga.h .AUTODEPEND
$(objdir)\dpmi.obj     : dpmi.cpp dpmi.h .AUTODEPEND
$(objdir)\x86_fake.obj : x86_fake.asm .AUTODEPEND
$(objdir)\near.obj     : near.cpp .AUTODEPEND
