# Main Makefile for the HERMES library
# Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
# This source code is licensed under the GNU LGPL
#
# Please refer to the file COPYING.LIB contained in the distribution for
# licensing conditions
#
# Adapted for DOS port of PTC by Jonathan Matthew (jmatthew@uq.net.au)

.SILENT
.EXTENSIONS:
.EXTENSIONS: .exe .lib .obj .c .h .asm

DEBUGLIBFILE = ..\..\library\debug\hermes.lib
RELEASELIBFILE = ..\..\library\release\hermes.lib

ASM_FLAGS = -f win32

!ifeq config debug
FLAGS = -zq -d2 -bt=dos -dDEBUG
LIBFILE = $(DEBUGLIBFILE)
OBJDIR = ..\..\library\debug
!else
FLAGS = -oneatx -zq -bt=dos
LIBFILE = $(RELEASELIBFILE)
OBJDIR = ..\..\library\release
!endif

!ifeq asm yes
ASMFILES = mmx_32.obj x86_32.obj x86_16.obj x86_i8.obj mmx_clr.obj x86_clr.obj
!else
FLAGS += -dNO_ASSEMBLER
!endif

CFILES = Hermes.c Conv_GC.c Conv_MMX.c Conv_x86.c c_muhmu.c c_32.c c_24.c &
  c_16.c c_8.c clearmmx.c clearx86.c clear_gc.c
OFILES1 = $(objdir)\Hermes.obj $(objdir)\Conv_GC.obj
OFILES2 = $(objdir)\Conv_MMX.obj $(objdir)\Conv_x86.obj
OFILES3 = $(objdir)\c_muhmu.obj $(objdir)\c_32.obj
OFILES4 = $(objdir)\c_24.obj $(objdir)\c_16.obj
OFILES5 = $(objdir)\c_8.obj $(objdir)\clearmmx.obj
OFILES6 = $(objdir)\clearx86.obj $(objdir)\clear_gc.obj

$(LIBFILE): hello $(OFILES1) $(OFILES2) $(OFILES3) $(OFILES4) $(OFILES5) $(OFILES6) $(ASMFILES)
        wlib -q -n -b $(LIBFILE) $(OFILES1)
        wlib -q -b $(LIBFILE) $(OFILES2)
        wlib -q -b $(LIBFILE) $(OFILES3)
        wlib -q -b $(LIBFILE) $(OFILES4)
        wlib -q -b $(LIBFILE) $(OFILES5)
        wlib -q -b $(LIBFILE) $(OFILES6)
!ifeq asm yes
        wlib -q -b $(LIBFILE) $(ASMFILES)
!endif

hello: .SYMBOLIC
        echo Compiling Hermes pixel conversion library..

.c.obj:
        wcc386 $(FLAGS) $[@ -fo=$@

.asm.obj:
        nasm $(ASM_FLAGS) -o $@ $[@

clean:  .SYMBOLIC
        if exist *.obj del *.obj

clobber: clean .SYMBOLIC
        if exist $(DEBUGLIBFILE) del $(DEBUGLIBFILE)
        if exist $(RELEASELIBFILE) del $(RELEASELIBFILE)

Hermes.obj: Hermes.c Hermes.h HermConf.h Base.h Conv_GC.h Conv_MMX.h Conv_x86.h
Conv_GC.obj: Conv_GC.c Hermes.h HermConf.h Base.h Conv_GC.h
Conv_MMX.obj: Conv_MMX.c Hermes.h HermConf.h Base.h Conv_MMX.h Head_MMX.h
Conv_x86.obj: Conv_x86.c Hermes.h HermConf.h Base.h Conv_x86.h Head_x86.h
c_32.obj: c_32.c Conv_GC.h Base.h Hermes.h HermConf.h
c_24.obj: c_24.c Conv_GC.h Base.h Hermes.h HermConf.h
c_16.obj: c_16.c Conv_GC.h Base.h Hermes.h HermConf.h
c_8.obj: c_8.c Conv_GC.h Base.h Hermes.h HermConf.h
Clear_GC.o: Clear_GC.c Hermes.h HermConf.h hrconfig.h Clear_GC.h Base.h
Clearx86.o: Clearx86.c Hermes.h HermConf.h hrconfig.h Clearx86.h Base.h Head_x86.h
ClearMMX.o: ClearMMX.c Hermes.h HermConf.h hrconfig.h ClearMMX.h Base.h Head_MMX.h
