# Watcom C++ top level makefile for ptc-dos-2.0.5
# Rename to just 'makefile' to actually use it.

version=2.0.5

.silent

!ifeq asm yes
ASMFLAG = "asm=yes"
!endif

all : debug release examples .SYMBOLIC

debug : .SYMBOLIC
        cd source
        wmake /h config=debug $(ASMFLAG)
        cd hermes
        wmake /h config=debug $(ASMFLAG)
        cd ..\..

release : .SYMBOLIC
        cd source
        wmake /h config=release $(ASMFLAG)
        cd hermes
        wmake /h config=release $(ASMFLAG)
        cd ..\..

examples : .SYMBOLIC
        cd examples
        wmake /h
        cd ..

clean : .SYMBOLIC
        cd source
        wmake /h clean
        cd hermes
        wmake /h clean
        cd ..\..\examples
        wmake /h clean
        cd ..

clobber : .SYMBOLIC
        cd source
        wmake /h clobber
        cd hermes
        wmake /h clobber
        cd ..\..\examples
        wmake /h clobber
        cd ..

# only reason I do it like this is it's the only way around LFN hassles.
dist : .SYMBOLIC
        if exist ptcdos.zip del ptcdos.zip
        if exist ptc-dos-$(version).zip del ptc-dos-$(version).zip
        pkzip -ex -r -p ptcdos *.*
        ren ptcdos.zip ptc-dos-$(version).zip
