//
// Mode class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// package
package ptc;



public class Mode implements Cloneable
{
    public Mode()
    {
        // defaults
        valid = false;
        width = 0;
        height = 0;
    }

    public Mode(int width,int height,Format format)
    {
        // setup data
        this.valid = true;
        this.width = width;
        this.height = height;
        this.format = format.copy();
    }

    public boolean valid()
    {
        // get valid
        return valid;
    }

    public int width()
    {
        // get width
        return width;
    }

    public int height()
    {
        // get height
        return height;
    }

    public Format format()
    {
        // get format copy
        return format.copy();
    }

    public Mode copy()
    {
        try
        {
            // clone mode object
            return (Mode) clone();
        }
        catch (CloneNotSupportedException e)
        {
            // failure
            return null;
        }
    }

    public boolean compare(Mode mode)
    {
        // compare mode data
        if (valid==mode.valid && width==mode.width && height==mode.height && format.compare(mode.format)) return true;
        else return false;
    }

    // mode data
    private boolean valid;
    private int width;
    private int height;
    private Format format;
}
