//
// Console class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// package
package ptc;



public class Console implements ptc.base.Console
{
    public Console() throws Error
    {
        // initialize factory
        Factory.initialize();

        // create console object
        console = Factory.console();
    }

    protected void finalize() throws Error
    {
        // close console
        console.close();

        // null console
        console = null;
    }

    public void configure(String file) throws Error
    {
        // configure console
        console.configure(file);
    }

    public boolean option(String option) throws Error
    {
        // not recognized
        return false;
    }

    public Mode[] modes() throws Error
    {
        // get console modes
        return console.modes();
    }

    public void open(String title) throws Error
    {
        // open console
        console.open(title);
    }

    public void open(String title,int pages) throws Error
    {
        // open console
        console.open(title,pages);
    }

    public void open(String title,Format format) throws Error
    {
        // open console
        console.open(title,format);
    }

    public void open(String title,Format format,int pages) throws Error
    {
        // open console
        console.open(title,format,pages);
    }

    public void open(String title,int width,int height,Format format) throws Error
    {
        // open console
        console.open(title,width,height,format);
    }

    public void open(String title,int width,int height,Format format,int pages) throws Error
    {
        // open console
        console.open(title,width,height,format,pages);
    }

    public void open(String title,Mode mode) throws Error
    {
        // open console
        console.open(title,mode);
    }

    public void open(String title,Mode mode,int pages) throws Error
    {
        // open console
        console.open(title,mode,pages);
    }

    public void close() throws Error
    {
        // close console
        console.close();
    }

    public void flush() throws Error
    {
        // flush console
        console.flush();
    }

    public void finish() throws Error
    {
        // finish console
        console.finish();
    }

    public void update() throws Error
    {
        // update console
        console.update();
    }

    public void update(Area area) throws Error
    {
        // update console area
        console.update(area);
    }

    public boolean key() throws Error
    {
        // check for key press
        return console.key();
    }

    public Key read() throws Error
    {
        // read key press
        return console.read();
    }

    public void copy(ptc.base.Surface surface) throws Error
    {
        // copy console to surface
        console.copy(surface);
    }

    public void copy(ptc.base.Surface surface,Area source,Area destination) throws Error
    {
        // copy console area to surface area
        console.copy(surface,source,destination);
    }

    public Object lock() throws Error
    {
        // lock console
        return console.lock();
    }

    public void unlock() throws Error
    {
        // unlock console
        console.unlock();
    }

    public void load(Object pixels,int width,int height,int pitch,Format format,Palette palette) throws Error
    {
        // load pixels to console
        console.load(pixels,width,height,pitch,format,palette);
    }

    public void load(Object pixels,int width,int height,int pitch,Format format,Palette palette,Area source,Area destination) throws Error
    {
        // load pixels to console area
        console.load(pixels,width,height,pitch,format,palette,source,destination);
    }

    public void save(Object pixels,int width,int height,int pitch,Format format,Palette palette) throws Error
    {
        // save console pixels
        console.save(pixels,width,height,pitch,format,palette);
    }

    public void save(Object pixels,int width,int height,int pitch,Format format,Palette palette,Area source,Area destination) throws Error
    {
        // save console area pixels
        console.save(pixels,width,height,pitch,format,palette,source,destination);
    }

    public void clear() throws Error
    {
        // clear console
        console.clear();
    }

    public void clear(Color color) throws Error
    {
        // clear console
        console.clear(color);
    }

    public void clear(Color color,Area area) throws Error
    {
        // clear console area
        console.clear(color,area);
    }

    public void palette(Palette palette) throws Error
    {
        // set console palette
        console.palette(palette);
    }

    public Palette palette() throws Error
    {
        // get console palette
        return console.palette();
    }

    public void clip(Area area) throws Error
    {
        // set console clip area
        console.clip(area);
    }

    public int width() throws Error
    {
        // get console width
        return console.width();
    }

    public int height() throws Error
    {
        // get console height
        return console.height();
    }

    public int pages() throws Error
    {
        // get console pages
        return console.pages();
    }

    public int pitch() throws Error
    {
        // get console pitch
        return console.pitch();
    }

    public Area area() throws Error
    {
        // get console area
        return console.area();
    }

    public Area clip() throws Error
    {
        // get console clip
        return console.clip();
    }
    
    public Format format() throws Error
    {
        // get console format
        return console.format();
    }

    public String name() throws Error
    {
        // get console name
        return console.name();
    }

    public String title() throws Error
    {
        // get console title
        return console.title();
    }

    public String information() throws Error
    {
        // get console information
        return console.information();
    }

    // internal console
    private ptc.base.Console console;
}
