//
// Color class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// package
package ptc;



public class Color implements Cloneable
{
    public Color()
    {
        // defaults
        index = 0;
        r = 0.0f;
        g = 0.0f;
        b = 0.0f;
        a = 1.0f;
        direct = false;
        indexed = false;
    }

    public Color(int index)
    {
        // indexed color
        this.index = index;
        r = 0.0f;
        g = 0.0f;
        b = 0.0f;
        a = 1.0f;
        direct = false;
        indexed = true;
    }

    public Color(float r,float g,float b)
    {
        // direct color
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        index = 0;
        direct = true;
        indexed = false;
    }

    public Color(float r,float g,float b,float a)
    {
        // direct color
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = 0.0f;
        index = 0;
        direct = true;
        indexed = false;
    }

    public int index()
    {
        // get index
        return index;
    }

    public float r()
    {
        // get r
        return r;
    }

    public float g()
    {
        // get g
        return g;
    }

    public float b()
    {
        // get b
        return b;
    }

    public float a()
    {
        // get a
        return a;
    }

    public boolean direct()
    {
        // get direct
        return direct;
    }

    public boolean indexed()
    {
        // get indexed
        return indexed;
    }

    public Color copy()
    {
        try
        {
            // clone color object
            return (Color) clone();
        }
        catch (CloneNotSupportedException e)
        {
            // failure
            return null;
        }
    }

    public boolean compare(Color color)
    {
        // check direct color
        if (direct && color.direct)
        {
            // check direct data
            if (r==color.r && g==color.g && b==color.b && a==color.a) return true;
            else return false;
        }
        else if (indexed && color.indexed)
        {
            // check indexed data
            if (index==color.index) return true;
            else return false;
        }
        else
        {
            // failure
            return false;
        }
    }
    // color data
    private int index;
    private float r;
    private float g;
    private float b;
    private float a;
    private boolean direct;
    private boolean indexed;
}
