//
// DirectX Display class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

#ifndef __PTC_DIRECTX_DISPLAY_H
#define __PTC_DIRECTX_DISPLAY_H

// include files
#include <ddraw.h>
#include <windows.h>
#include "Core/Config.h"
#include "Core/Format.h"
#include "Win32/Event.h"

// custom display messages
const WM_DIRECTX_OPEN  = WM_USER + 100;
const WM_DIRECTX_CLOSE = WM_USER + 101;




class DirectXDisplay
{
    public:

        // setup
        DirectXDisplay();
        ~DirectXDisplay();

        // display management
        void setup(LPDIRECTDRAW2 ddraw);
        bool test(int width,int height,const Format &format);
        void cooperative(HWND window,bool fullscreen);
        void open();
        void open(int width,int height,const Format &format);
        void close();

        // data access
        bool fullscreen() const;

    public:

        // display data
        struct Data
        {
            DirectXDisplay *display;
            const char *title;
            int width;
            int height;
            const Format *format;
            Win32Event event;
        };

    private:

        // data
        bool m_open;
        bool m_fullscreen;
        HWND m_window;
        LPDIRECTDRAW2 m_ddraw;
};




#endif
