//
// Timer class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

#ifndef __PTC_TIMER_H
#define __PTC_TIMER_H

// include files
#include "Core/Types.h"
#include "Core/Config.h"




class Timer
{
    public:

        // setup
        DLLAPI PTCAPI Timer();
        DLLAPI PTCAPI Timer(double time);
        DLLAPI PTCAPI Timer(const Timer &timer);
        DLLAPI PTCAPI ~Timer();

        // set time
        DLLAPI void PTCAPI set(double time);

        // control
        DLLAPI void PTCAPI start();
        DLLAPI void PTCAPI stop();

        // time data
        DLLAPI double PTCAPI time();
        DLLAPI double PTCAPI delta();
        DLLAPI double PTCAPI resolution();
    
        // operators
        DLLAPI Timer& PTCAPI operator =(const Timer &timer);
        DLLAPI bool PTCAPI operator ==(const Timer &timer) const;
        DLLAPI bool PTCAPI operator !=(const Timer &timer) const;

    private:

        // clock time
        double clock();

        // data
        double m_old;
        double m_time;
        double m_start;
        double m_current;
        bool m_running;
        __int64 m_frequency;
};




#endif
