//
// Surface class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

#ifndef __PTC_SURFACE_H
#define __PTC_SURFACE_H

// include files
#include "Core/Base.h"
#include "Core/Copy.h"
#include "Core/Area.h"
#include "Core/Types.h"
#include "Core/Clear.h"
#include "Core/Config.h"
#include "Core/Palette.h"




class Surface : public BaseSurface
{
    public:

        // setup
        DLLAPI PTCAPI Surface(int width,int height,const Format &format);
        DLLAPI PTCAPI ~Surface();

        // copy to surface
        DLLAPI virtual void PTCAPI copy(BaseSurface &surface);
        DLLAPI virtual void PTCAPI copy(BaseSurface &surface,const Area &source,const Area &destination);

        // memory access
        DLLAPI virtual void* PTCAPI lock();
        DLLAPI virtual void PTCAPI unlock();

        // load pixels to surface
        DLLAPI virtual void PTCAPI load(const void *pixels,int width,int height,int pitch,const Format &format,const Palette &palette);
        DLLAPI virtual void PTCAPI load(const void *pixels,int width,int height,int pitch,const Format &format,const Palette &palette,const Area &source,const Area &destination);

        // save surface pixels
        DLLAPI virtual void PTCAPI save(void *pixels,int width,int height,int pitch,const Format &format,const Palette &palette);
        DLLAPI virtual void PTCAPI save(void *pixels,int width,int height,int pitch,const Format &format,const Palette &palette,const Area &source,const Area &destination);

        // clear surface
        DLLAPI virtual void PTCAPI clear();
        DLLAPI virtual void PTCAPI clear(const Color &color);
        DLLAPI virtual void PTCAPI clear(const Color &color,const Area &area);

        // surface palette
        DLLAPI virtual void PTCAPI palette(const Palette &palette);
        DLLAPI virtual const Palette& PTCAPI palette() const;
   
        // surface clip area
        DLLAPI virtual void PTCAPI clip(const Area &area);
        
        // data access
        DLLAPI virtual int PTCAPI width() const;
        DLLAPI virtual int PTCAPI height() const;
        DLLAPI virtual int PTCAPI pitch() const;
        DLLAPI virtual const Area& PTCAPI area() const;
        DLLAPI virtual const Area& PTCAPI clip() const;
        DLLAPI virtual const Format& PTCAPI format() const;

        // surface option string
        DLLAPI virtual bool PTCAPI option(const char option[]);

    private:

        // disallow copy construction
        Surface(const Surface &surface);

        // disallow surface assignment
        Surface& operator =(const Surface &surface);

        // data
        int m_width;
        int m_height;
        int m_pitch;
        Area m_area;
        Area m_clip;
        Format m_format;
        bool m_locked;
        void *m_pixels;
        
        // objects
        Copy m_copy;
        Clear m_clear;
        Palette m_palette;
};




#endif
