//
// Type definitions for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

#ifndef __PTC_TYPES_H
#define __PTC_TYPES_H

// include files
#include "Config.h"




//
// Integral types
// --------------
//
// Known size integral types are required by OpenPTC implementation
// for correct operation across all platforms.
//
// char8   - unsigned 32 bit integer
// short16 - unsigned 16 bit integer
// int32   - unsigned  8 bit integer
// 
// If the typedefs below do not match what is required above then
// the OpenPTC implementation will not work correctly!
//
// NOTE: If you upgrade OpenPTC to use Hermes with the Hermes Kit
// you will be provided with the right size integral types in all
// situations. See the comments in "Copy.cpp" for more information
// about upgrading using Hermes.
//

// integral type definitions
typedef unsigned char char8;
typedef unsigned short short16;
typedef unsigned long int32;


#ifndef __COMPILER_SUPPORTS_BOOL__

    // emulate 'bool'
    typedef int bool;
    const true = 1;
    const false = 0;

#endif




#endif
