//
// Mode class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// include files
#include "Mode.h"
#include "Error.h"
#include "Config.h"




Mode::Mode()
{
    // defaults
    m_valid = false;
    m_width = 0;
    m_height = 0;
}


Mode::Mode(int width,int height,const Format &format)
{
    // setup data
    m_valid = true;
    m_width = width;
    m_height = height;
    m_format = format;
}


Mode::Mode(const Mode &mode)
{
    // assignment
    *this = mode;
}


Mode::~Mode()
{
    // destructor
}




bool Mode::valid() const
{
    // get valid flag
    return m_valid;
}




int Mode::width() const
{
    // check
    check();

    // get width
    return m_width;
}


int Mode::height() const
{
    // check
    check();

    // get height
    return m_height;
}


const Format& Mode::format() const
{
    // check
    check();

    // get format
    return m_format;
}




Mode& Mode::operator =(const Mode &mode)
{
    // check for self assignment
    if (this==&mode) throw Error("self assignment is not allowed");
        
    // assignment
    m_valid = mode.m_valid;
    m_width = mode.m_width;
    m_height = mode.m_height;
    m_format = mode.m_format;
    return *this;
}


bool Mode::operator ==(const Mode &mode) const
{
    // equal to
    if (m_valid==mode.m_valid && 
        m_width==mode.m_width && 
        m_height==mode.m_height && 
        m_format==mode.m_format) return true;

    // failure
    return false;
}


bool Mode::operator !=(const Mode &mode) const
{
    // not equal to
    return !(*this==mode);
}




void Mode::check() const
{
    //
    // Check that mode is valid
    // ------------------------
    //
    // This function is used in Mode member functions that are only 
    // defined while the mode is valid.
    //
    // If __DEBUG__ is defined, then it throws an exception to indicate 
    // that the mode operation is not valid while the mode is invalid.
    //
    // If __DEBUG__ is not defined, it performs no checking whether or not 
    // the mode is valid. This is for efficiency, nobody wants a check on 
    // every mode.width/mode.height/mode.format in release build!
    //

    #ifdef __DEBUG__

        // check that mode is valid
        if (!m_valid) throw Error("mode is not valid");

    #else

        // no checking in release build

    #endif
}
