//
// Error class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

#ifndef __PTC_ERROR_H
#define __PTC_ERROR_H

// include files
#include "Types.h"




class Error
{
    public:

        // setup
        Error();
        Error(const char message[]);
        Error(const char message[],const Error &error);
        Error(const Error &error);
        ~Error();

        // report error
        void report() const;

        // get error message
        const char* message() const;

        // operators
        Error& operator =(const Error &error);
        bool operator ==(const Error &error) const;
        bool operator !=(const Error &error) const;

    private:

        // defaults
        void defaults();

        // error message
        char *m_message;
};




#endif
