//
// Clear class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// include files
#include <string.h>
#include "Clear.h"
#include "Color.h"
#include "Error.h"
#include "Config.h"




Clear::Clear()
{
    // default constructor
}


Clear::~Clear()
{
    // destructor
}




void Clear::request(const Format &format)
{
    // request a clear format
    m_format = format;
}



void Clear::clear(void *pixels,int x,int y,int width,int height,int pitch,const Color &color)
{
    //
    // NOTE: this copy implementation does not properly support clear color
    //
    // To support clearing with the specified color you will need to
    // upgrade the clear object to use the Hermes library.
    //
    // To do this, you must download the latest version of Hermes from
    // http://hermes.terminal.at and get the latest version of the Hermes
    // Kit from the OpenPTC developers download site:
    // http://www.gaffer.org/ptc/download/development/hermes
    //
    // Read the text files that come with the Hermes Kit for further
    // instructions.
    //

    #ifdef __DEBUG__

        //
        // This checking is performed only when __DEBUG__ is defined,
        // and can be used to track down errors early caused by passing
        // null pointers to the clear function.
        //
        // Even though technically clear should never recieve a null
        // pointer, we provide a check here to assist in debugging
        // just in case it ever does!
        //

        // check pixels pointer
        if (!pixels) throw Error("null pixels pointer in clear");

    #else

        // no checking is performed in release build

    #endif

    // setup clear value
    int value = 0;
    if (color.direct() && (color.r() || color.g() || color.b())) value = 0xFFFFFFFF;
    else if (color.direct() && color.index()) value = 0xFFFFFFFF;

    // get memory pointers
    char8 *s = ((char8*)pixels) + pitch*y + x*m_format.bytes();

    // calculate bytes per clear line
    const int bytes = width * m_format.bytes();

    // clear a line at a time
    for (int i=0; i<height; i++)
    {
        // clear line to value
        memset(s,value,bytes);

        // next line
        s += pitch;
    }
}
