//
// Copy class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_COPY_H
#define __PTC_COPY_H

// include files
#include "Index.h"
#include "Types.h"




class Copy
{
    public:

        // setup
        Copy();
        ~Copy();
        
        // request conversion between pixel formats
        void request(const Format &source,const Format &destination);

        // set conversion palettes
        void palette(const Palette &source,const Palette &destination);
        
        // copy pixels
        void copy(const void *source_pixels,int source_x,int source_y,int source_width,int source_height,int source_pitch,
                  void *destination_pixels,int destination_x,int destination_y,int destination_width,int destination_height,int destination_pitch);

        // copy option string
        bool option(const char option[]);

    private:

        // disallow copy construction
        Copy(const Copy &copy);

        // disallow assignment
        Copy& operator =(const Copy &copy);

        // data
        int m_bytes;
};




#endif
