//
// Clear class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_CLEAR_H
#define __PTC_CLEAR_H

// include files
#include "Index.h"
#include "Format.h"




class Clear
{
    public:

        // setup
        Clear();
        ~Clear();
        
        // request clear
        void request(const Format &format);
        
        // clear pixels
        void clear(void *pixels,int x,int y,int width,int height,int pitch,const Color &color);

    private:
        
        // disallow copy construction
        Clear(const Clear &clear);

        // disallow assignment
        Clear& operator =(const Clear &clear);

        // data
        Format m_format;
};




#endif
