//
// Format class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_FORMAT_H
#define __PTC_FORMAT_H

// include files
#include "Core/Copy.h"
#include "Core/Types.h"
#include "Core/Clear.h"
#include "Core/Config.h"
#include "Core/Hermes.h"




class Format
{
    public:

        // setup
        DLLAPI PTCAPI Format();
        DLLAPI PTCAPI Format(int bits);
        DLLAPI PTCAPI Format(int bits,int32 r,int32 g,int32 b,int32 a=0);
        DLLAPI PTCAPI Format(const Format &format);
        DLLAPI PTCAPI ~Format();

        // data access
        DLLAPI int32 PTCAPI r() const;
        DLLAPI int32 PTCAPI g() const;
        DLLAPI int32 PTCAPI b() const;
        DLLAPI int32 PTCAPI a() const;
        DLLAPI int PTCAPI bits() const;
        DLLAPI int PTCAPI bytes() const;
        DLLAPI bool PTCAPI direct() const;
        DLLAPI bool PTCAPI indexed() const;

        // operators
        DLLAPI Format& PTCAPI operator =(const Format &format);
        DLLAPI bool PTCAPI operator ==(const Format &format) const;
        DLLAPI bool PTCAPI operator !=(const Format &format) const;

    private:

        // hermes format
        HermesFormat m_format;

        // friend functions
        friend void Clear::request(const Format &format);
        friend void Copy::request(const Format &source,const Format &destination);
};




#endif
