//
// Color class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_COLOR_H
#define __PTC_COLOR_H

// include files
#include "Core/Types.h"
#include "Core/Config.h"




class Color
{
    public:

        // setup
        DLLAPI PTCAPI Color();
        DLLAPI PTCAPI Color(int index);
        DLLAPI PTCAPI Color(float r,float g,float b,float a=1.0f);
        DLLAPI PTCAPI Color(const Color &color);
        DLLAPI PTCAPI ~Color();

        // data access
        DLLAPI int PTCAPI index() const;
        DLLAPI float PTCAPI r() const;
        DLLAPI float PTCAPI g() const;
        DLLAPI float PTCAPI b() const;
        DLLAPI float PTCAPI a() const;
        DLLAPI bool PTCAPI direct() const;
        DLLAPI bool PTCAPI indexed() const;

        // operators
        DLLAPI Color& PTCAPI operator =(const Color &color);
        DLLAPI bool PTCAPI operator ==(const Color &color) const;
        DLLAPI bool PTCAPI operator !=(const Color &color) const;

    private:

        // data
        int m_index;
        float m_r;
        float m_g;
        float m_b;
        float m_a;
        bool m_direct;
        bool m_indexed;
};




#endif
