//
// X11 windowed demonstration program for OpenPTC 1.0 C++ API
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// The OpenPTC 1.0 C++ API is (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//
// This program is going to demonstrate how to make PTC render into a user
// supplied window rather than create its own. This leaves you with the
// burden of initialising everything.
//

#include <X11/Xlib.h>
#include <stdlib.h>
#include <iostream.h>
#include "ptc.h"


int main()
{
  Display *disp;

  disp=XOpenDisplay(0);   // First, open the display
  if(!disp)
  { cerr << "Can't open DISPLAY" << endl << flush;
    exit(0);
  }


  Window window;          // Create a 400x300 window
  window=XCreateSimpleWindow(disp,DefaultRootWindow(disp),0,0,400,300,0,0,0);


  // Give that poor window a title
  XTextProperty textprop; 
  char *windowname="PTC X11 Native window";
  XStringListToTextProperty(&windowname,1,&textprop);
  XSetWMName(disp,window,&textprop);
  XFree(textprop.value);



  // Now it's time to actually bring the thing on the screen
  XSelectInput(disp,window,StructureNotifyMask); 
  XMapWindow(disp,window);


  for(;;)                 // Wait for server notification
  { XEvent e;

    XNextEvent(disp,&e);
    if(e.type==MapNotify) break;
  }


  // Select KeyPress and KeyRelease mask. This is IMPORTANT if you want to
  // use the PTC key() and read() routines. You are free to select any
  // additional mask you want though. If you do your own event handling, you
  // can of course leave this out.
  XSelectInput(disp,window,KeyPress|KeyRelease);
  XSync(disp,0);



  // Now, if you want, you can use PTC
  Format format(32,0x00FF0000,0x0000FF00,0x000000FF);

  try {
    // We won't use the constructor. We have to call a specific open routine
    Console console;

    // Note how you have to tell PTC to leave the window and the display
    // intact after exiting. This is important, otherwise your program will
    // crash if you still try to access anything after closing the console.
    // This has to be done before open is called
    console.option("dga off");
    console.option("leave window open");
    console.option("leave display open");

    console.open(disp,DefaultScreen(disp),window,format,40,50,320,200);

    // If you want PTC to use the whole window instead of an area (as above)
    // then use this open routine (comment out the one above)
    /*
    console.open(disp,DefaultScreen(disp),window,format,
                 PTC_X11_LEAVE_WINDOW|PTC_X11_LEAVE_DISPLAY); */



    // Create a surface same size as the console but with RGB888 format
    Surface surface(console.width(),console.height(),format);


    while(!console.key())
    { int32 *data=(int32 *)surface.lock();


      // Make the whole surface white
      for(int j=0;j<console.height();j++)
      for(int i=0;i<console.width();i++)
      *(data+j*console.width()+i)=0xFFFFFF;

      surface.unlock();


      // Update the screen
      surface.copy(console);

            
      console.update();
    }

    while (console.key())
    console.read();                // Remove the pressed key from the queue

    console.close();
  }
  catch(Error e)
  { // You do not have to report the error and exit if PTC is just a small
    // part of your application. For now, we will.
    e.report();
  }

  // Your program could continue here.. Let's just draw some lines


  XGCValues xgcv;                            // Get a graphics context
  xgcv.graphics_exposures=false;
  GC gc=XCreateGC(disp,window,GCGraphicsExposures,&xgcv);
  
  XSetForeground(disp,gc,BlackPixel(disp,DefaultScreen(disp)));
  XDrawLine(disp,window,gc,0,0,399,299);     // And draw
  XSetForeground(disp,gc,WhitePixel(disp,DefaultScreen(disp)));
  XDrawLine(disp,window,gc,399,0,0,299);
  XFlush(disp);

  // Press any key...
  XEvent e;
  XMaskEvent(disp,KeyPress,&e);

  return 0;
}






