//
// Error class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Error.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>




Error::Error()
{
    // clear error message
}


Error::Error(const char message[])
{
    // set error message
    strcpy(this->m_message,message);
}


Error::Error(const Error &other)
{
    // assignment
    *this = other;
}


Error::~Error()
{
    // destructor
}




void Error::rethrow(const char message[])
{
    // todo: prepend message

    // rethrow
    throw *this;
}




void Error::report() const
{
    // report error
    printf("error: %s\n",m_message);

    // exit
    exit(1);
}




const char* Error::message() const
{
    // get message
    return m_message;
}




Error& Error::operator =(const Error &other)
{
    // assignment
    strcpy(m_message,other.m_message);
    return *this;
}


bool Error::operator ==(const Error &other) const
{
    // is equal to
    if (!strcmp(other.m_message,m_message)) return true;
    else return false;
}


bool Error::operator !=(const Error &other) const
{
    // not equal to
    return !(*this==other);
}
