//
// Console class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_CONSOLE_H
#define __PTC_CONSOLE_H

// include files
#include "Types.h"
#include "Base.h"
#include "Copy.h"
#include "Clear.h"
#include "Format.h"
#include "Palette.h"

#include "VBE.h"
#include "VGA.h"

class Console : public BaseConsole
{
    public:

        // setup
        Console();
        ~Console();

        // console option string
        virtual bool option(const char string[]);

        // console management
        virtual void open(const char title[]);
        virtual void open(const char title[],const Format &format);
        virtual void open(const char title[],int width,int height,const Format &format);
        virtual void close();

        // synchronization
        virtual void update();
        virtual void update(const Area &area);

        // keyboard input
        virtual bool key();
        virtual int read();

        // copy to surface
        virtual void copy(BaseSurface &surface);
        virtual void copy(BaseSurface &surface,const Area &source,const Area &destination);

        // memory access
        virtual void* lock();
        virtual void unlock();

        // load pixels to console
        virtual void load(const void *pixels,int width,int height,const Format &format,const Palette &palette);
        virtual void load(const void *pixels,int width,int height,const Area &source,const Area &destination,const Format &format,const Palette &palette);

        // save console pixels
        virtual void save(void *pixels,int width,int height,const Format &format,const Palette &palette);
        virtual void save(void *pixels,int width,int height,const Area &source,const Area &destination,const Format &format,const Palette &palette);

        // clear console
        virtual void clear(const Color &color);
        virtual void clear(const Color &color,const Area &area);

        // set console palette
        virtual void palette(const Palette &palette);
        virtual const Palette& palette() const;

        // data access
        virtual int width() const;
        virtual int height() const;
        virtual int pitch() const;
        virtual const Format& format() const;
        virtual const char* name() const;

        // API extensions for VBE/VGA port:
        virtual bool vrstate();         // get wait for retrace state
        virtual void vrstate(bool newstate); // set wait for retrace state


    private:

        // disallow console assignment and copy construction
        Console& operator =(const Surface &other);
        Console(const Console &console);

        // data
        int m_width;
        int m_height;
        int m_pitch;
        Format m_format;
        bool m_locked;
        int m_bufmode;
        int m_banked;
        int m_drawpage, m_displaypage, m_sparepage;
        char *m_offscreen;  // for single buffered mode

        // configuration
        bool m_disallow_banked;
        bool m_force_offscreen;
        bool m_flexible;
        bool m_wait_retrace;
        bool m_wide_dac;
        bool m_vga_modes;
        bool m_pmode_interface;

        // utility objects
        Copy m_copy;
        Clear m_clear;
        VBE *m_vbe;
        VGA *m_vga;
        Palette m_palette;
};




#endif
