//
// Image example for PTC 2.0 C++ API
// Copyright (c) Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU GPL
//

// include files
#include "ptc.h"
#include <fstream.h>


void load(Surface &surface,char filename[])
{
    // open image file
    ifstream is(filename,ios::binary);

    // skip header
    is.seekg(18);

    // get surface dimensions
    int width  = surface.width();
    int height = surface.height();
    
    // allocate image pixels
    char8 *pixels = new char8[width*height*3];

    // read image pixels one line at a time
    for (int y=height-1; y>=0; y--) is.read((char*)&pixels[width*y*3],width*3);

    // load pixels to surface
    surface.load(pixels,width,height,Format(24,0x00FF0000,0x0000FF00,0x000000FF),Palette());

    // free image pixels
    delete[] pixels;
}


void center(const Surface &surface,const Console &console,Area &source,Area &destination)
{
    // calculate origin to center surface on console
    int cx = ( console.width()  - surface.width()  ) / 2;
    int cy = ( console.height() - surface.height() ) / 2;

    // clip to zero
    if (cx<0) cx = 0;
    if (cy<0) cy = 0;

    // setup width and height of surface
    int width  = surface.width();
    int height = surface.height(); 

    // clip to console width and height
    if (width>console.width())   width  = console.width();
    if (height>console.height()) height = console.height();

    // setup source and destination areas
    source = Area(0,0,width,height);
    destination = Area(cx,cy,cx+width,cy+height);
}


void main()
{
    try
    {
        // create console
        Console console;

        // create format
        Format format(32,0x00FF0000,0x0000FF00,0x000000FF);
 
        try
        {
            // try to open the console matching the image resolution
            console.open("Area example",320,200,format);
        }
        catch (Error&)
        {
            // fallback to the default resolution
            console.open("Area example",format);
        }

        // create surface
        Surface surface(320,200,format);

        // load image to surface
        load(surface,"Image.tga");

        // create copy areas
        Area source,destination;

        // setup copy areas to center surface on console
        center(surface,console,source,destination);

        // copy surface to center of console
        surface.copy(console,source,destination);
    
        // update console
        console.update();

        // read key
        console.read();

        // finished
        return 0;
    }
    catch (Error &error)
    {
        // report error
        error.report();
    }
}
