//
// Visual class for PTC 2.0 C++ API
// Copyright (c) 1998 Jarno Paananen (jpaana@s2.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_GGI_VISUAL_H
#define __PTC_GGI_VISUAL_H

// include files
#include <ggi/ggi.h>
#include "Core/Copy.h"
#include "Core/Clear.h"
#include "Base/Types.h"
#include "Core/Format.h"
#include "Core/Palette.h"




namespace ptc
{
    namespace GGI
    {
        class Visual
        {
            public:

                // setup
                Visual(char* visual, int width, int height,
                       const ptc::Base::Format &format, bool fullscreen);
                ~Visual();

                // synchronization
                void update();

                // copy to surface
                void copy(Base::Surface &surface);
                void copy(Base::Surface &surface,const Base::Area &source,const Base::Area &destination);

                // memory access
                void* lock();
                void unlock();

                // load pixels to Visual
                void load(const void *pixels,int width,int height,const Base::Format &format,const Base::Palette &palette);
                void load(const void *pixels,int width,int height,const Base::Area &source,const Base::Area &destination,const Base::Format &format,const Base::Palette &palette);

                // save Visual pixels
                void save(void *pixels,int width,int height,const Base::Format &format,const Base::Palette &palette);
                void save(void *pixels,int width,int height,const Base::Area &source,const Base::Area &destination,const Base::Format &format,const Base::Palette &palette);

                // clear Visual pixels
                void clear(const Base::Color &color);
                void clear(const Base::Color &color,const Base::Area &area);

                // palette routines
                void palette(const Base::Palette &palette);
                const Base::Palette& palette() const;

                // input routines
                int key() const;
                int read() const;
            
                // access
                int width() const;
                int height() const;
                int pitch() const;
                const Base::Format& format() const;

            private:
                // pixel format translation
                Core::Format translate(ggi_graphtype const &type);

                // close
                void close();

                // data
                int m_width;
                int m_height;
                Core::Format m_format;

                // GGI stuff
                ggi_visual_t m_vis;
                ggi_mode     m_mode;
            
                // fullscreen flag
                bool m_fullscreen;

                // objects
                Core::Copy m_copy;
                Core::Clear m_clear;
                Core::Palette m_palette;
        };
    }
}




#endif
