//
// GGI Console implementation for PTC 2.0 C++ API
// Copyright (c) 1998 Jarno Paananen (jpaana@s2.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Core/Error.h"
#include "Core/Format.h"
#include "GGI/GGIConsole.h"

// using directive
using namespace ptc::GGI;

// using declarations
using ptc::Core::Error;
using ptc::Core::Format;


Console::Console()
{
    // defaults
    m_visual = NULL;
    m_fullscreen = false;
}


Console::~Console()
{
    // close
    close();
}




bool Console::option(const char string[])
{
    // no options at the moment
    return false;
}




void Console::open(const char title[])
{
    // todo: smart default format
    
    // default format
    Format format(32,0x00FF0000,0x0000FF00,0x000000FF);

    // open console
    open(title,format);
}


void Console::open(const char title[],const ptc::Base::Format &format)
{
    // todo: smart default width and height

    // default width and height
    int width  = 640;
    int height = 480;

    // open console
    open(title,width,height,format);
}


void Console::open(const char title[],int width,int height,const ptc::Base::Format &format)
{
    try
    {
        // try fullscreen output
        open(title,width,height,format,true);
    }
    catch (Error&)
    {
        // try windowed output
        open(title,width,height,format,false);
    }
}


void Console::open(const char title[],int width,int height,
                   const ptc::Base::Format &format,bool fullscreen)
{
    // close
    close();

    // create display
    m_visual = new Visual(NULL, width, height, format, fullscreen);

    // not fullscreen output
    m_fullscreen = false;
}


void Console::close()
{
    // free visual
    delete m_visual;
    m_visual = NULL;

}


void Console::update()
{
    // update visual
    m_visual->update();
}


void Console::update(const ptc::Base::Area &area)
{
    // update
    update();
}


bool Console::key()
{
    // check for keypress
    return m_visual->key();
}


int Console::read()
{
    // read keypress
    return m_visual->read();
}


void Console::copy(ptc::Base::Surface &surface)
{
    // copy visual to surface
    m_visual->copy(surface);
}


void Console::copy(ptc::Base::Surface &surface,const ptc::Base::Area &source,const ptc::Base::Area &destination)
{
    // copy visual area to surface area
    m_visual->copy(surface,source,destination);
}


void* Console::lock()
{
    // lock visual
    return m_visual->lock();
}


void Console::unlock()
{
    // unlock console
    m_visual->unlock();
}




void Console::load(const void *pixels,int width,int height,const ptc::Base::Format &format,const ptc::Base::Palette &palette)
{
    // load pixels to visual
    m_visual->load(pixels,width,height,format,palette);
}


void Console::load(const void *pixels,int width,int height,const ptc::Base::Area &source,const ptc::Base::Area &destination,const ptc::Base::Format &format,const ptc::Base::Palette &palette)
{
    // load pixels to visual
    m_visual->load(pixels,width,height,source,destination,format,palette);
}




void Console::save(void *pixels,int width,int height,const ptc::Base::Format &format,const ptc::Base::Palette &palette)
{
    // save visual pixels
    m_visual->save(pixels,width,height,format,palette);
}


void Console::save(void *pixels,int width,int height,const ptc::Base::Area &source,const ptc::Base::Area &destination,const ptc::Base::Format &format,const ptc::Base::Palette &palette)
{
    // save visual pixels
    m_visual->save(pixels,width,height,source,destination,format,palette);
}




void Console::clear(const ptc::Base::Color &color)
{
    // clear visual
    m_visual->clear(color);
}


void Console::clear(const ptc::Base::Color &color,const ptc::Base::Area &area)
{
    // clear visual area
    m_visual->clear(color,area);
}




void Console::palette(const ptc::Base::Palette &palette)
{
    // set palette
    m_visual->palette(palette);
}


const ptc::Base::Palette& Console::palette() const
{
    // get palette
    return m_visual->palette();
}




int Console::width() const
{
    // get width of console
    return m_visual->width();
}


int Console::height() const
{
    // get height of console
    return m_visual->height();
}


int Console::pitch() const
{
    // get pitch of console
    return m_visual->pitch();
}


const ptc::Base::Format& Console::format() const
{
    // get format of console
    return m_visual->format();
}


const char* Console::name() const
{
    // get console name
    return "GGI";
}
