//
// Core Palette implementation for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_CORE_PALETTE_H
#define __PTC_CORE_PALETTE_H

// include files
#include "Base/Palette.h"




namespace ptc
{
    namespace Core
    {
        class Palette : public Base::Palette
        {
            public:

                // setup
                Palette();
                Palette(const Palette &other);
                virtual ~Palette();

                // memory access
                virtual int32 *lock();
                virtual void unlock();

                // load palette data
                virtual void load(const int32 data[]);

                // save palette data
                virtual void save(int32 data[]) const;
        
                // get palette data
                virtual const int32* data() const;

                // operators
                Palette& operator =(const Palette &other);
                virtual Base::Palette& operator =(const Base::Palette &other);
                virtual bool operator ==(const Base::Palette &other) const;
                virtual bool operator !=(const Base::Palette &other) const;

            private:

                // locked flag
                bool m_locked;

                // palette data
                int32 m_data[256];
        };
    }
}




#endif
