//
// Core Copy class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include <memory.h>
#include "Core/Copy.h"
#include "Core/Error.h"
#include "Core/Format.h"
#include "Base/Palette.h"

// using directive
using namespace ptc::Core;




Copy::Copy()
{
    // initialize hermes
    HermesInit();
}


Copy::~Copy()
{   
    // close hermes
    HermesClose();
}


void Copy::request(const ptc::Base::Format &source,const ptc::Base::Format &destination)
{
    // no stretching is required
    char hermes_stretch = 0;

    // translate formats
    HermesFormat hermes_source;
    HermesFormat hermes_destination;
    translate(source,&hermes_source);
    translate(destination,&hermes_destination);

    // request hermes copy
    int result = HermesRequest(&hermes_source,&hermes_destination,hermes_stretch);

    // check hermes copy request result
    if (!result) throw Error("unsupported pixel format conversion");
}




void Copy::palette(const ptc::Base::Palette &source,const ptc::Base::Palette &destination)
{
    // note: destination palette is not supported yet by hermes

    // set copy palettes
    HermesPalette((int32*)source.data());
}




void Copy::copy(const void *s_pixels,int s_x,int s_y,int s_width,int s_height,int s_pitch,
                void *d_pixels,int d_x,int d_y,int d_width,int d_height,int d_pitch)
{
    // check is stretching is required
    if (s_width!=d_width || s_height!=d_height) throw Error("stretching is not implemented");

    // copy source pixels to destination pixels
    HermesCopy(const_cast<void *>(s_pixels),s_x,s_y,s_width,s_height,s_pitch,d_pixels,d_x,d_y,d_width,d_height,d_pitch);
}




void Copy::translate(const ptc::Base::Format& source,HermesFormat *destination)
{ 
    // translate format to hermes format
    destination->bpp     = source.bits();
    destination->mask_r  = source.r();
    destination->mask_g  = source.g();
    destination->mask_b  = source.b();
    destination->indexed = source.direct() ? 0 : 1;
}
