//
// Core Console implementation for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Core/Area.h"
#include "Core/Clip.h"
#include "Core/Error.h"
#include "Core/Console.h"

// console implementations
#include "GGI/GGIConsole.h"

// using directive
using namespace ptc::Core;




Console::Console()
{
    // create console
    console = new ptc::GGI::Console;
}


Console::~Console()
{
    // delete console
    delete console;
}




bool Console::option(const char string[])
{
    // set console option
    return console->option(string);
}




void Console::open(const char title[])
{
    // open console
    console->open(title);
}


void Console::open(const char title[],const ptc::Base::Format &format)
{
    // open console
    console->open(title,format);
}


void Console::open(const char title[],int width,int height,const ptc::Base::Format &format)
{
    // create console
    if (!console) console = new ptc::GGI::Console;

    // open console
    console->open(title,width,height,format);
}


void Console::close()
{
    // close console
    console->close();
}




void Console::update()
{
    // update console
    console->update();
}


void Console::update(const ptc::Base::Area &area)
{
    // update console area
    console->update(area);
}




bool Console::key()
{
    // check for key press
    return console->key();
}


int Console::read()
{
    // read key press
    return console->read();
}




void Console::copy(ptc::Base::Surface &surface)
{
    // copy console to surface
    console->copy(surface);
}


void Console::copy(ptc::Base::Surface &surface,const ptc::Base::Area &source,const ptc::Base::Area &destination)
{
    // copy console area to surface area
    console->copy(surface,source,destination);
}




void* Console::lock()
{
    // lock console
    return console->lock();
}


void Console::unlock()
{
    // unlock console
    console->unlock();
}




void Console::load(const void *pixels,int width,int height,const ptc::Base::Format &format,const ptc::Base::Palette &palette)
{
    // load pixels to console
    console->load(pixels,width,height,format,palette);
}


void Console::load(const void *pixels,int width,int height,const ptc::Base::Area &source,const ptc::Base::Area &destination,const ptc::Base::Format &format,const ptc::Base::Palette &palette)
{
    // load pixels to console area
    console->load(pixels,width,height,source,destination,format,palette);
}




void Console::save(void *pixels,int width,int height,const ptc::Base::Format &format,const ptc::Base::Palette &palette)
{
    // save console pixels
    console->save(pixels,width,height,format,palette);
}


void Console::save(void *pixels,int width,int height,const ptc::Base::Area &source,const ptc::Base::Area &destination,const ptc::Base::Format &format,const ptc::Base::Palette &palette)
{
    // save console area pixels
    console->save(pixels,width,height,source,destination,format,palette);
}




void Console::clear(const ptc::Base::Color &color)
{
    // clear console
    console->clear(color);
}


void Console::clear(const ptc::Base::Color &color,const ptc::Base::Area &area)
{
    // clear console area
    console->clear(color,area);
}




void Console::palette(const ptc::Base::Palette &palette)
{
    // set console palette
    console->palette(palette);
}


const ptc::Base::Palette& Console::palette() const
{
    // get console palette
    return console->palette();
}




int Console::width() const
{
    // get width of console
    return console->width();
}


int Console::height() const
{
    // get height of console
    return console->height();
}


int Console::pitch() const
{
    // get pitch of console
    return console->pitch();
}


const ptc::Base::Format& Console::format() const
{
    // get format of console
    return console->format();
}


const char* Console::name() const
{
    // get name of console
    return console->name();
}
