//
// Core Color implementation for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_CORE_COLOR_H
#define __PTC_CORE_COLOR_H

// include files
#include "Base/Color.h"




namespace ptc
{
    namespace Core
    {
        class Color : public Base::Color
        {
            public:

                // setup
                Color();
                Color(int index);
                Color(float r,float g,float b,float a=1.0f);
                Color(const Base::Color &color);

                // data access
                virtual int index() const;
                virtual float r() const;
                virtual float g() const;
                virtual float b() const;
                virtual float a() const;
                virtual bool direct() const;
                virtual bool indexed() const;

                // operators
                Color& operator =(const Color &other);
                virtual Base::Color& operator =(const Base::Color &other);
                virtual bool operator ==(const Base::Color &other) const;
                virtual bool operator !=(const Base::Color &other) const;

            private:

                // data
                int m_index;
                float m_r;
                float m_g;
                float m_b;
                float m_a;
                bool m_direct;
                bool m_indexed;
        };
    }
}




#endif
