//
// Core Color implementation for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Core/Color.h"
#include "Core/Error.h"

// using directive
using namespace ptc::Core;




Color::Color()
{
    // defaults
    m_index = 0;
    m_r = 0.0f;
    m_g = 0.0f;
    m_b = 0.0f;
    m_a = 1.0f;
    m_direct = false;
    m_indexed = false;
}


Color::Color(int index)
{
    // indexed color
    m_index = index;
    m_r = 0.0f;
    m_g = 0.0f;
    m_b = 0.0f;
    m_a = 1.0f;
    m_direct = false;
    m_indexed = true;
}


Color::Color(float r,float g,float b,float a)
{
    // direct color
    m_index = 0;
    m_r = r;
    m_g = g;
    m_b = b;
    m_a = a;
    m_direct = true;
    m_indexed = false;
}


Color::Color(const ptc::Base::Color &other)
{
    // copy constructor
    *this = other;
}




int Color::index() const
{
    // get index
    return m_index;
}


float Color::r() const
{
    // get r
    return m_r;
}


float Color::g() const
{
    // get g
    return m_g;
}


float Color::b() const
{
    // get b
    return m_b;
}


float Color::a() const
{
    // get a
    return m_a;
}


bool Color::direct() const
{
    // get direct
    return m_direct;
}


bool Color::indexed() const
{
    // get indexed
    return m_indexed;
}




Color& Color::operator =(const Color &other)
{
    // assignment
    m_index = other.m_index;
    m_r = other.m_r;
    m_g = other.m_g;
    m_b = other.m_b;
    m_a = other.m_a;
    m_direct = other.m_direct;
    m_indexed = other.m_indexed;
    return *this;
}


ptc::Base::Color& Color::operator =(const ptc::Base::Color &other)
{
    // assignment
    m_index = other.index();
    m_r = other.r();
    m_g = other.g();
    m_b = other.b();
    m_a = other.a();
    m_direct = other.direct();
    m_indexed = other.indexed();
    return *this;
}


bool Color::operator ==(const ptc::Base::Color &other) const
{
    // equal to
    if (m_direct && other.direct())
    {
        // direct color
        if (m_r==other.r() && 
            m_g==other.g() && 
            m_b==other.b() && 
            m_a==other.a()) return true;
    }
    else if (m_indexed && other.indexed())
    {
        // indexed color
        if (m_index==other.index()) return true;
    }

    // failure
    return false;
}


bool Color::operator !=(const ptc::Base::Color &other) const
{
    // not equal to
    return !(*this==other);
}
