//
// Core Area implementation for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_CORE_AREA_H
#define __PTC_CORE_AREA_H

// include files
#include "Base/Area.h"




namespace ptc
{
    namespace Core
    {
        class Area : public Base::Area
        {
            public:

                // setup
                Area();
                Area(int left,int top,int right,int bottom);
                Area(const Base::Area &other);

                // data access
                virtual int left()   const;
                virtual int right()  const;
                virtual int top()    const;
                virtual int bottom() const;
                virtual int width()  const;
                virtual int height() const;

                // operators
                Area& operator =(const Area &other);
                virtual Base::Area& operator =(const Base::Area &other);
                virtual bool operator ==(const Base::Area &other) const;
                virtual bool operator !=(const Base::Area &other) const;

            private:

                // data
                int m_left;
                int m_right;
                int m_top;
                int m_bottom;
        };
    }
}




#endif
