//
// Base Palette interface for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_BASE_PALETTE_H
#define __PTC_BASE_PALETTE_H

// include files
#include "Base/Types.h"




namespace ptc
{
    namespace Base
    {
        class Palette
        {
            public:

                // load palette data
                virtual void load(const int32 data[]) = 0;

                // memory access
                virtual int32* lock() = 0;
                virtual void unlock() = 0;

                // save palette data
                virtual void save(int32 data[]) const = 0;
        
                // get palette data
                virtual const int32* data() const = 0;

                // operators
                virtual Palette& operator =(const Palette &other) = 0;
                virtual bool operator ==(const Palette &other) const = 0;
                virtual bool operator !=(const Palette &other) const = 0;
        };
    }
}




#endif
