//
// Base Console interface classes for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_BASE_CONSOLE_H
#define __PTC_BASE_CONSOLE_H

// include files
#include "Base/Index.h"
#include "Base/Types.h"
#include "Base/Surface.h"




namespace ptc
{
    namespace Base
    {
        class Console : public Surface
        {
            public:

                // virtual destructor
                virtual ~Console() {};

                // console option string
                virtual bool option(const char string[]) = 0;

                // console management
                virtual void open(const char title[]) = 0;
                virtual void open(const char title[],const Format &format) = 0;
                virtual void open(const char title[],int width,int height,const Format &format) = 0;
                virtual void close() = 0;

                // synchronization
                virtual void update() = 0;
                virtual void update(const Area &area) = 0;

                // keyboard input
                virtual bool key() = 0;
                virtual int read() = 0;

                // data access
                virtual const char* name() const = 0;
        };
    }
}




#endif
