//
// Base Color interface for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_BASE_COLOR_H
#define __PTC_BASE_COLOR_H




namespace ptc
{
    namespace Base
    {
        class Color
        {
            public:

                // data access
                virtual int index() const = 0;
                virtual float r() const = 0;
                virtual float g() const = 0;
                virtual float b() const = 0;
                virtual float a() const = 0;
                virtual bool direct() const = 0;
                virtual bool indexed() const = 0;

                // operators
                virtual Color& operator =(const Color &other) = 0;
                virtual bool operator ==(const Color &other) const = 0;
                virtual bool operator !=(const Color &other) const = 0;
        };
    }
}




#endif
