//
// Base Area interface for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_AREA_H
#define __PTC_AREA_H




namespace ptc
{
    namespace Base
    {
        class Area
        {
            public:

                // data access
                virtual int left()   const = 0;
                virtual int right()  const = 0;
                virtual int top()    const = 0;
                virtual int bottom() const = 0;
                virtual int width()  const = 0;
                virtual int height() const = 0;

                // operators
                virtual Area& operator =(const Area &other) = 0;
                virtual bool operator ==(const Area &other) const = 0;
                virtual bool operator !=(const Area &other) const = 0;
        };
    }
}




#endif
