//
// Clear example for PTC 2.0 C++ API
// Copyright (c) Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU GPL
//

// include files
#include "ptc.h"
#include <stdlib.h>


inline int random_ptc(int max)
{
    // random_ptc number
    return rand() % max;
}


inline float random_ptc()
{
    // random_ptc float
    return rand() / (float)RAND_MAX;
}


int main(void)
{
    try
    {
        // create console
        Console console;
        
        // create format
        Format format(32,0x00FF0000,0x0000FF00,0x000000FF);
 
        // open the console
        console.open("Clear example",format);

        // create surface matching console dimensions
        Surface surface(console.width(),console.height(),format);
        
        // loop until a key is pressed
        while (!console.key())
        {
            // get surface dimensions
            int width  = surface.width();
            int height = surface.height();

            // setup clear area
            Area area(random_ptc(width),random_ptc(height),random_ptc(width),random_ptc(height));

            // create random_ptc color
            Color color(random_ptc(),random_ptc(),random_ptc());
            
            // clear surface area with color
            surface.clear(color,area);
            
            // copy to console
            surface.copy(console);
            
            // update console
            console.update();
        }
        
        // finished
        return 0;
    }
    catch (Error &error)
    {
        // report error
        error.report();
    }
}
