/*
 * Configuration file for OpenPTC 1.0 C++ Implementation
 * Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
 * This source code is licensed under the GNU LGPL
 * See http://www.gnu.org/copyleft/lgpl.html for details
 */

#ifndef __PTC_CONFIG_H
#define __PTC_CONFIG_H




/* ptc signature */
#define __PTC__


/* ptc version define */
#define __PTC_VERSION__ "OpenPTC 1.0"


/* ptc platform signature */
#define __PTC_WIN32__


/* ptc platform version define */
#define __PTC_WIN32_VERSION__ "OpenPTC Win32 1.0.13"


/* ptc dll version defines */
#define __PTC_DLL_VERSION__ 1,0,13,0
#define __PTC_DLL_VERSION_STRING__ "1,0,13,0\0"


#ifdef __cplusplus

    // use dynamic classes
    #define __PTC_DYNAMIC__

    // enable jni support
    #define __PTC_JNI__

    // enable rni support
    #define __PTC_RNI__

    // enable jdirect support
    #define __PTC_JDIRECT__

    // enable logging support
    #define __PTC_LOGGING__

    // enable directx error strings
    #define __PTC_DIRECTX_ERROR_STRINGS__

    // check compiler
    #if (_MSC_VER>=1100)

        // Visual C++ 5.0 and greater

        // compiler has boolean type support
        #define __COMPILER_SUPPORTS_BOOL__

        // compiler has const_cast support
        #define __COMPILER_SUPPORTS_CONST_CAST__

        // compiler has namespace support
        #define __COMPILER_SUPPORTS_NAMESPACES__

    #else

        // unknown compiler

        // define this if the compiler has boolean type support
        #define __COMPILER_SUPPORTS_BOOL__

        // define this if the compiler has const_cast support
        #define __COMPILER_SUPPORTS_CONST_CAST__

        // define this if the compiler has namespace support
        #define __COMPILER_SUPPORTS_NAMESPACES__

    #endif

    // check compiler bool type support
    #ifndef __COMPILER_SUPPORTS_BOOL__

        // emulate 'bool'
        typedef int bool;
        const true = 1;
        const false = 0;

    #endif

#endif


/* enable win32 extensions */
#define __PTC_WIN32_EXTENSIONS__


/* configure hermes */
#define __HERMES_C__


/* check compiler */
#if (_MSC_VER>=1100)

    /* Visual C/C++ 5.0 and greater */

    /* debug checking */
    #ifdef _DEBUG
    #define __DEBUG__
    #endif

    /* ptc api convention */
    #define PTCAPI __stdcall

    /* c api convention */
    #ifdef __cplusplus
    #define CAPI extern "C"
    #else
    #define CAPI
    #endif

    /* callback convention */
    #define PTC_CALLBACK _cdecl

#else

    /* unknown compiler */

    /* ptc api convention */
    #include <windows.h>
    #define PTCAPI WINAPI

    /* c api convention */
    #ifdef __cplusplus
    #define CAPI extern "C"
    #else
    #define CAPI
    #endif

    /* callback convention */
    #define PTC_CALLBACK

#endif




#endif
