//
// Console class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// include files
#include <stdio.h>
#include <string.h>
#include <fstream.h>
#include "Core/Log.h"
#include "Core/Key.h"
#include "Core/Area.h"
#include "Core/Color.h"
#include "Core/Error.h"
#include "Core/Console.h"

// include consoles
#include "GDI/Console.h"
#include "DirectX/Console.h"




PTCAPI Console::Console()
{
    // create console
    console = new DirectXConsole();
}


PTCAPI Console::~Console()
{
    // destroy console
    delete console;
}




void PTCAPI Console::configure(const char file[])
{
    // configure console
    console->configure(file);
}




bool PTCAPI Console::option(const char option[])
{
    // set console option
    return console->option(option);
}




const Mode* PTCAPI Console::modes()
{
    // get console modes
    return console->modes();
}




void PTCAPI Console::open(const char title[],int pages)
{
    // open console
    console->open(title,pages);
}


void PTCAPI Console::open(const char title[],const Format &format,int pages)
{
    // open console
    console->open(title,format,pages);
}


void PTCAPI Console::open(const char title[],int width,int height,const Format &format,int pages)
{
    // open console
    console->open(title,width,height,format,pages);
}


void PTCAPI Console::open(const char title[],const Mode &mode,int pages)
{
    // open console
    console->open(title,mode,pages);
}


void PTCAPI Console::close()
{
    // close console
    console->close();
}




void PTCAPI Console::flush()
{
    // flush console
    console->flush();
}


void PTCAPI Console::finish()
{
    // finish console
    console->finish();
}


void PTCAPI Console::update()
{
    // update console
    console->update();
}


void PTCAPI Console::update(const Area &area)
{
    // update console area
    console->update(area);
}




bool PTCAPI Console::key()
{
    // check for key press
    return console->key();
}

                         
Key PTCAPI Console::read()
{
    // read key press
    return console->read();
}




void PTCAPI Console::copy(BaseSurface &surface)
{
    // copy console to surface
    console->copy(surface);
}


void PTCAPI Console::copy(BaseSurface &surface,const Area &source,const Area &destination)
{
    // copy console area to surface area
    console->copy(surface,source,destination);
}




void* PTCAPI Console::lock()
{
    // lock console
    return console->lock();
}


void PTCAPI Console::unlock()
{
    // unlock console
    console->unlock();
}




void PTCAPI Console::load(const void *pixels,int width,int height,int pitch,const Format &format,const Palette &palette)
{
    // load pixels to console
    console->load(pixels,width,height,pitch,format,palette);
}


void PTCAPI Console::load(const void *pixels,int width,int height,int pitch,const Format &format,const Palette &palette,const Area &source,const Area &destination)
{
    // load pixels to console area
    console->load(pixels,width,height,pitch,format,palette,source,destination);
}




void PTCAPI Console::save(void *pixels,int width,int height,int pitch,const Format &format,const Palette &palette)
{
    // save console pixels
    console->save(pixels,width,height,pitch,format,palette);
}


void PTCAPI Console::save(void *pixels,int width,int height,int pitch,const Format &format,const Palette &palette,const Area &source,const Area &destination)
{
    // save console area pixels
    console->save(pixels,width,height,pitch,format,palette,source,destination);
}




void PTCAPI Console::clear()
{
    // clear console
    console->clear();
}


void PTCAPI Console::clear(const Color &color)
{
    // clear console
    console->clear(color);
}


void PTCAPI Console::clear(const Color &color,const Area &area)
{
    // clear console area
    console->clear(color,area);
}




void PTCAPI Console::palette(const Palette &palette)
{
    // set console palette
    console->palette(palette);
}


const Palette& PTCAPI Console::palette() const
{
    // get console palette
    return console->palette();
}




void PTCAPI Console::clip(const Area &area)
{
    // set console clip area
    console->clip(area);
}




int PTCAPI Console::width() const
{
    // get console width
    return console->width();
}


int PTCAPI Console::height() const
{
    // get console height
    return console->height();
}


int PTCAPI Console::pages() const
{
    // get console pages
    return console->pages();
}


int PTCAPI Console::pitch() const
{
    // get console pitch
    return console->pitch();
}


const Area& PTCAPI Console::area() const
{
    // get console area
    return console->area();
}


const Area& PTCAPI Console::clip() const
{
    // get console clip area
    return console->clip();
}


const Format& PTCAPI Console::format() const
{
    // get console format
    return console->format();
}


const char* PTCAPI Console::name() const
{
    // get console name
    return console->name();
}


const char* PTCAPI Console::title() const
{
    // get console title
    return console->title();
}


const char* PTCAPI Console::information() const
{
    // get console information
    return console->information();
}




#ifdef __PTC_WIN32_EXTENSIONS__


void PTCAPI Console::open(HWND window,int pages)
{
    // open console
    console->open(window,pages);
}


void PTCAPI Console::open(HWND window,const Format &format,int pages)
{
    // open console
    console->open(window,format,pages);
}


void PTCAPI Console::open(HWND window,int width,int height,const Format &format,int pages)
{
    // open console
    console->open(window,width,height,format,pages);
}


void PTCAPI Console::open(HWND window,const Mode &mode,int pages)
{
    // open console
    console->open(window,mode,pages);
}


HWND PTCAPI Console::window() const
{
    // get console window
    return console->window();
}


LPDIRECTDRAW PTCAPI Console::lpDD() const
{
    // get console lpDD
    return console->lpDD();
}


LPDIRECTDRAW2 PTCAPI Console::lpDD2() const
{
    // get console lpDD2
    return console->lpDD2();
}



LPDIRECTDRAWSURFACE PTCAPI Console::lpDDS() const
{
    // get console lpDDS
    return console->lpDDS();
}



LPDIRECTDRAWSURFACE PTCAPI Console::lpDDS_primary() const
{
    // get console lpDDS primary
    return console->lpDDS_primary();
}



LPDIRECTDRAWSURFACE PTCAPI Console::lpDDS_secondary() const
{
    // get console lpDDS secondary
    return console->lpDDS_secondary();
}


#endif
