//
// Header definitions for the x86 routines for the HERMES library
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//
#ifndef __HERMES_HEAD_X86__
#define __HERMES_HEAD_X86__


#ifndef NO_ASSEMBLER

// If you can't stand IFDEFS, then close your eyes now, please :)

// Ok, we start with normal function definitions
#ifdef __cplusplus
extern "C" {
#endif


#if defined __GNUC__
void ConvertX86(HermesInterface *) __attribute__ ((regparm(1)));
#else
void ConvertX86(HermesInterface *);
#endif // GNUC

void Convert32_32RGB888();
void Convert32_16RGB565();
void Convert32_16RGB555();
void Convert32_8RGB332();

void ConvertI8_32();
void ConvertI8_16();
void ConvertI8_INDEX8();

void ConvertI8_SetLookup(void *lookup);

#ifdef __cplusplus
}
#endif




// Now fix up the ELF underscore problem

#if defined(__ELF__) && defined(__GNUC__)
  #ifdef __cplusplus
  extern "C" {
  #endif

  void ConvertX86(HermesInterface *) __attribute__ ((alias ("_ConvertX86"))) 
	 __attribute__ ((regparm(1)));
  void Convert32_32RGB888() __attribute__ ((alias ("_Convert32_32RGB888")));
  void Convert32_16RGB565() __attribute__ ((alias ("_Convert32_16RGB565")));
  void Convert32_16RGB555() __attribute__ ((alias ("_Convert32_16RGB555")));
  void Convert32_8RGB332() __attribute__ ((alias ("_Convert32_8RGB332")));

  void ConvertI8_32() __attribute__ ((alias ("_ConvertI8_32")));
  void ConvertI8_16() __attribute__ ((alias ("_ConvertI8_16")));
  void ConvertI8_INDEX8() __attribute__ ((alias ("_ConvertI8_INDEX8")));
 
  void ConvertI8_SetLookup(void *lookup) __attribute__ ((alias ("_ConvertI8_SetLookup")));

  #ifdef __cplusplus
  }
  #endif

#endif // ELF & GNU



// Make it run with WATCOM C
#ifdef __WATCOMC__
#pragma warning 601 9
#pragma aux ConvertX86 "_*" parm [EAX] modify [EAX EBX ECX EDX ESI EDI]
#pragma aux Convert32_32RGB888 "_*"
#pragma aux Convert32_16RGB565 "_*"
#pragma aux Convert32_16RGB555 "_*"
#pragma aux Convert32_8RGB332 "_*"

#pragma aux ConvertI8_32 "_*"
#pragma aux ConvertI8_16 "_*"
#pragma aux ConvertI8_INDEX8 "_*"
#pragma aux ConvertI8_SetLookup "_*"
#endif // __WATCOMC__



#endif // NO_ASSEMBLER


#endif 
