//
// Generic C definitions for the HERMES library
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//
#ifndef __HERMES_CONV_GC_H__
#define __HERMES_CONV_GC_H__

#include <stdlib.h>
#include "Base.h"

void Hermes_GC_init();

void Hermes_GC_close();

char Hermes_GC_request(HermesFormat *source,HermesFormat *dest,char stretch);

void Hermes_GC_palette(int32 *palette);

void Hermes_GC_copy(void *s_pixels,int s_x,int s_y,int s_width,int s_height,
		   int s_pitch,void *d_pixels,int d_x,int d_y,int d_width,
		   int d_height,int d_pitch);

static BaseConverter Hermes_Generic_C=
{ NULL, 
  NULL,
  0,
  Hermes_GC_init,
  Hermes_GC_close,
  Hermes_GC_request,
  Hermes_GC_palette,
  Hermes_GC_copy
};


// Help routines
void Hermes_GC_Calculate_Generic_Info(HermesFormat *format);
int Hermes_GC_topbit(int32 mask);

// Converters

// From 32 bit RGB
void Hermes_GC_32rgb888_32rgb888(char *source,char *dest,unsigned int count);
void Hermes_GC_32rgb888_24rgb888(char *source,char *dest,unsigned int count);
void Hermes_GC_32rgb888_24bgr888(char *source,char *dest,unsigned int count);
void Hermes_GC_32rgb888_16rgb565(char *source,char *dest,unsigned int count);
void Hermes_GC_32rgb888_16rgb555(char *source,char *dest,unsigned int count);
void Hermes_GC_32rgb888_8rgb332(char *source,char *dest,unsigned int count);
void Hermes_GC_32rgb888_Generic32(char *source,char *dest,unsigned int count);
void Hermes_GC_32rgb888_Generic16(char *source,char *dest,unsigned int count);

// From 24 bit RGB
void Hermes_GC_24rgb888_Generic32(char *source,char *dest,unsigned int count);
void Hermes_GC_24rgb888_Generic16(char *source,char *dest,unsigned int count);
void Hermes_GC_24rgb888_8rgb332(char *source,char *dest,unsigned int count);

// From 8 bit indexed
void Hermes_GC_index8_32(char *source,char *dest,unsigned int count);
void Hermes_GC_index8_24(char *source,char *dest,unsigned int count);
void Hermes_GC_index8_16(char *source,char *dest,unsigned int count);
void Hermes_GC_index8_i8(char *source,char *dest,unsigned int count);

#endif

