//
// Basic structures for the HERMES library
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//
#ifndef __HERMES_BASE_H__
#define __HERMES_BASE_H__

#include "Hermes.h"


typedef struct {
  char *s_pixels;
  int s_width,s_height;
  int s_add;

  char *d_pixels;
  int d_width,d_height;
  int d_add;

  void (*conv_func)(void);
} HermesInterface;

typedef struct {
  HermesFormat *m_source,*m_dest;
  char m_stretch;

  void (*init)(void);            // Initialise this converter
  void (*close)(void);           // Deinitialise this convert

  char (*request)(HermesFormat *source,HermesFormat *dest,char stretch);
  void (*palette)(int32 *palette);
  
  void (*copy)(void *s_pixels,int s_x,int s_y,int s_width,int s_height,
	       int s_pitch,void *d_pixels,int d_x,int d_y,int d_width,
	       int d_height,int d_pitch);
} BaseConverter;


#endif
