//
// Palette example for OpenPTC 1.0 C++ Implementation
// Copyright (c) Glenn Fiedler (ptc@gaffer.org)
// This source code is in the public domain
//

// import classes
import ptc.Error;
import ptc.Format;
import ptc.Surface;
import ptc.Console;



class Palette
{
    public static void main(String argv[])
    {
        try
        {
            // create console
            Console console = new Console();
        
            // create format
            Format format = new Format(8);
 
            // open the console
            console.open("Palette example",format);

            // create surface matching console dimensions
            Surface surface = new Surface(console.width(),console.height(),format);
        
            // create palette
            ptc.Palette palette = new ptc.Palette();

            // generate palette
            int data[] = new int[256];
            for (int i=0; i<256; i++) data[i] = i;

            // load palette data
            palette.load(data);

            // set console palette
            console.palette(palette);
        
            // set surface palette
            surface.palette(palette);

            // loop until a key is pressed
            while (!console.key())
            {
                // lock surface pixels
                byte pixels[] = (byte[]) surface.lock();

                // get surface dimensions
                final int width  = surface.width();
                final int height = surface.height();

                // draw random pixels
                for (int i=0; i<100; i++)
                {
                    // get random position
                    final int x = random(width);
                    final int y = random(height);

                    // get random color index
                    final byte index = (byte) random(256);

                    // draw color [index] at position [x,y]
                    pixels[x+y*width] = index;
                }
        
                // unlock surface
                surface.unlock();

                // copy to console
                surface.copy(console);

                // update console
                console.update();
            }

            // close console
            console.close();
        }
        catch (Error error)
        {
            // report error
            error.report();
        }
        
        // exit program
        System.exit(0);
    }

    static int random(int number)
    {
        // random number routine
        return (int) ( Math.random() * number );
    }
}

