//
// Info example for OpenPTC 1.0 Java Implementation
// Copyright (c) Glenn Fiedler (ptc@gaffer.org)
// This source code is in the public domain
//

// import classes
import ptc.Error;
import ptc.Format;
import ptc.Console;



class Info
{
    public static void main(String argv[])
    {
        try
        {
            // create console
            Console console = new Console();

            // open the console
            console.open("Info example");

            // print console data
            System.out.println("[console data]");
            System.out.println("name   = " + console.name());
            System.out.println("title  = " + console.title());
            System.out.println("width  = " + console.width());
            System.out.println("height = " + console.height());
            System.out.println("pages  = " + console.pages());
            System.out.println("pitch  = " + console.pitch());
            System.out.print("format = ");
            print(console.format());
            System.out.println();

            // print console information
            System.out.println("[console information]");
            System.out.println(console.information());

            // close console
            console.close();
        }
        catch (Error error)
        {
            // report error
            error.report();
        }

        // exit program
        System.exit(0);
    }

    static void print(Format format) throws Error
    {
        // check format type
        if (format.direct())
        {
            // check alpha
            if (format.a()==0)
            {
                // direct color format without alpha
                System.out.println("Format(" + format.bits() + "," + format.r() + "," + format.g() + "," + format.b() + ")");
            }
            else
            {
                // direct color format with alpha
                System.out.println("Format(" + format.bits() + "," + format.r() + "," + format.g() + "," + format.b() + "," + format.a() + ")");
            }
        }
        else
        {
            // indexed color format
            System.out.println("Format(" + format.bits() + ")");
        }
    }
}
