//
// Image example for OpenPTC 1.0 Java Implementation
// Copyright (c) Glenn Fiedler (ptc@gaffer.org)
// This source code is in the public domain
//

// import classes
import ptc.Error;
import ptc.Format;
import ptc.Surface;
import ptc.Console;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;
import java.awt.image.ImageObserver;



class Image
{
    public static void main(String argv[])
    {
        try
        {
            // create console
            Console console = new Console();

            // create format
            Format format = new Format(32,0x00FF0000,0x0000FF00,0x000000FF);

            try
            {
                // try to open the console matching the image resolution
                console.open("Image example",320,200,format);
            }
            catch (Error error)
            {
                // fallback to the default resolution
                console.open("Image example",format);
            }

            // create surface
            Surface surface = new Surface(320,200,format);

            // load image to surface
            load(surface,"Image.jpg");

            // copy to console
            surface.copy(console);

            // update console
            console.update();

            // read key
            console.read();

            // close console
            console.close();
        }
        catch (Error error)
        {
            // report error
            error.report();
        }
        
        // exit program
        System.exit(0);
    }

    public static void load(Surface surface,String filename) throws Error
    {
        // get default awt toolkit
        Toolkit toolkit = Toolkit.getDefaultToolkit();

        // load image
        java.awt.Image image = toolkit.getImage(filename);

        // lock surface pixels
        int pixels[] = (int[]) surface.lock();

        // create image grabber
        PixelGrabber pg = new PixelGrabber(image,0,0,surface.width(),surface.height(),pixels,0,surface.width());
        
        try 
        {
            // grab pixels
         pg.grabPixels();
        } 
        catch (InterruptedException e) 
        {
            // error message
            throw new Error("interrupted during image load");
        }

        // check if pixel grab succeeded
        if ((pg.getStatus() & ImageObserver.ABORT) != 0) throw new Error("failed to load image");

        // unlock surface
        surface.unlock();
    }
}