//
// Java Keyboard class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// package name
package ptc.java;

// import classes
import ptc.Key;
import ptc.Error;
import java.awt.event.KeyEvent;
import java.awt.event.KeyAdapter;



public class Keyboard extends KeyAdapter
{
    public Keyboard()
    {
        // defaults
        head = 0;
        tail = 0;
    }

    public boolean key()
    {
        // check if ready
        return ready();
    }

    public Key read()
    {
        // wait until ready
        while (!ready());

        // remove key
        return remove();
    }

    public void keyPressed(KeyEvent event)
    {
        // get key data
        final int code = event.getKeyCode();
        final boolean alt = event.isAltDown();
        final boolean shift = event.isShiftDown();
        final boolean control = event.isControlDown();

        // create key object from key data
        Key key = new Key(code,alt,shift,control);

        // insert key
        insert(key);
    }

    private synchronized void insert(Key key)
    {
        // check for overflow
        if (head!=tail-1)
        {
            // insert key at head
            buffer[head] = key; 
    
            // increase head
            head ++;

            // wrap head from end to start
            if (head==buffer.length) head = 0;
        }
    }


    private synchronized Key remove()
    {
        // get key data from tail
        Key key = buffer[tail];

        // null key in buffer
        buffer[tail] = null;

        // increase tail
        tail ++;

        // wrap tail from end to start
        if (tail==buffer.length) tail = 0;

        // return key
        return key;
    }


    private synchronized boolean ready()
    {
        // check if key is ready
        return (head!=tail);
    }

    // keyboard data
    private int head;
    private int tail;
    private Key buffer[] = new Key[1024];
}
