//
// Pixel example for OpenPTC 1.0 Java Implementation
// Copyright (c) Glenn Fiedler (ptc@gaffer.org)
// This source code is in the public domain
//

// import classes
import ptc.Error;
import ptc.Format;
import ptc.Surface;
import ptc.Console;



class Pixel
{
    public static void main(String argv[])
    {
        try
        {
            // create console
            Console console = new Console();
        
            // create format
            Format format = new Format(32,0x00FF0000,0x0000FF00,0x000000FF);
 
            // open the console
            console.open("Pixel example",format);

            // create surface matching console dimensions
            Surface surface = new Surface(console.width(),console.height(),format);
        
            // plot a white pixel in the middle of the surface
            putpixel(surface,surface.width()/2,surface.height()/2,255,255,255);

            // copy to console
            surface.copy(console);
        
            // update console
            console.update();

            // read key
            console.read();
        }
        catch (Error error)
        {
            // report error
            error.report();
        }
        
        // exit program
        System.exit(0);
    }

    static void putpixel(Surface surface,int x,int y,int r,int g,int b) throws Error
    {
        // lock surface pixels
        int pixels[] = (int[]) surface.lock();

        // pack the color integer from r,g,b
        final int color = (r<<16) | (g<<8) | b;

        // plot the pixel on the surface
        pixels[x+y*surface.width()] = color;
    
        // unlock surface
        surface.unlock();
    }
}
