//
// Keyboard class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_WIN32_KEYBOARD_H
#define __PTC_WIN32_KEYBOARD_H

// include files
#include "Core/Config.h"
#include "Win32/Hook.h"
#include "Win32/Event.h"
#include "Win32/Window.h"
#include "Win32/Monitor.h"




class Win32Keyboard : public Win32Hook
{
    public:

        // setup
        Win32Keyboard(HWND window,DWORD thread,bool multithreaded);
        ~Win32Keyboard();

        // input
        bool key();
        int read(Win32Window &window);

    private:

        // window procedure
        virtual LRESULT WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam);

        // data
        bool m_key;
        bool m_multithreaded;
        Win32Event m_event;
        Win32Monitor m_monitor;

        // key buffer
        int m_index;
        int m_buffer[1024];
};




#endif
